﻿using System;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TheMVCPattern.Models;
using Microsoft.VisualStudio.TestTools.UnitTesting.Web;

namespace TestProject
{
    
    
[TestMethod()] 
public void CanAddBid() { 
 
    // Przygotowanie - skonfigurowanie scenariusza
    Item target = new Item();  
    Member memberParam = new Member(); 
    Decimal amountParam = 150M; 
 
    // Dziaanie - wykonanie operacji
    target.AddBid(memberParam, amountParam); 
             
    // Asercje - weryfikacja wyniku
    Assert.AreEqual(1, target.Bids.Count()); 
    Assert.AreEqual(amountParam, target.Bids[0].BidAmount); 
} 
 
[TestMethod()] 
[ExpectedException(typeof(InvalidOperationException))] 
public void CannotAddLowerBid() { 
 
    // Przygotowanie 
    Item target = new Item(); 
    Member memberParam = new Member(); 
    Decimal amountParam = 150M; 
    // Dziaanie
    target.AddBid(memberParam, amountParam); 
    target.AddBid(memberParam, amountParam - 10); 
} 
 
[TestMethod()] 
public void CanAddHigherBid() { 
 
    // Przygotowanie
    Item target = new Item(); 
    Member firstMember = new Member(); 
    Member secondMember = new Member(); 
    Decimal amountParam = 150M; 
 
    // Dziaanie
    target.AddBid(firstMember, amountParam); 
    target.AddBid(secondMember, amountParam + 10);
                 
    // Asercje
    Assert.AreEqual(2, target.Bids.Count()); 
    Assert.AreEqual(amountParam + 10, target.Bids[1].BidAmount); 
} 
